/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.world.feature;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.common.block.SoulStalkBlock;
import com.momosoftworks.coldsweat.common.world.feature.SoulStalkFeatureConfig;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;

public class SoulStalkFeature
extends Feature<SoulStalkFeatureConfig> {
    public SoulStalkFeature(Codec<SoulStalkFeatureConfig> config) {
        super(config);
    }

    public boolean isAirOrLeaves(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_204336_(BlockTags.f_13035_);
    }

    public boolean m_142674_(FeaturePlaceContext<SoulStalkFeatureConfig> context) {
        SoulStalkFeatureConfig config = (SoulStalkFeatureConfig)context.m_159778_();
        WorldGenLevel level = context.m_159774_();
        BlockPos.MutableBlockPos pos = context.m_159777_().m_122032_();
        int diskWidth = config.diskWidth();
        int diskHeight = config.diskHeight();
        RuleBasedBlockStateProvider diskProvider = config.diskStateProvider();
        BlockPredicate diskReplacer = config.replaceBlocks();
        int successes = 0;
        for (int t = 0; t < config.tries(); ++t) {
            pos.m_122190_((Vec3i)context.m_159777_()).m_122184_(context.m_225041_().m_188503_(config.spreadXZ()) - config.spreadXZ() / 2, context.m_225041_().m_188503_(config.spreadY()) - config.spreadY() / 2, context.m_225041_().m_188503_(config.spreadXZ()) - config.spreadXZ() / 2);
            int startY = pos.m_123342_();
            int minHeight = level.m_141937_();
            int maxHeight = level.m_151558_();
            for (int i = -10; i < 10; ++i) {
                pos.m_142448_(startY + i);
                if (pos.m_123342_() >= minHeight && (pos.m_123342_() > maxHeight || level.m_8055_((BlockPos)pos).m_60795_())) break;
            }
            if (!level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.SOUL_STALK_PLACEABLE_ON) && diskWidth > 0 && diskHeight > 0) {
                SoulStalkFeature.placeDisk(level, (BlockPos)pos, diskWidth, diskHeight, diskWidth, diskProvider, diskReplacer);
            }
            if (!level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.SOUL_STALK_PLACEABLE_ON) || !level.m_8055_(pos.m_7494_()).m_60795_()) continue;
            level.m_7731_((BlockPos)pos, ModBlocks.SOUL_STALK.m_49966_(), 2);
            int height = new Random().nextInt(5) + 2;
            for (int i = 0; i < height && this.isAirOrLeaves(level, pos.m_7494_()); ++i) {
                pos.m_122184_(0, 1, 0);
                level.m_7731_((BlockPos)pos, (BlockState)ModBlocks.SOUL_STALK.m_49966_().m_61124_((Property)SoulStalkBlock.SECTION, (Comparable)Integer.valueOf(new Random().nextInt(2) + 1)), 2);
            }
            level.m_7731_((BlockPos)pos, (BlockState)ModBlocks.SOUL_STALK.m_49966_().m_61124_((Property)SoulStalkBlock.SECTION, (Comparable)Integer.valueOf(3)), 2);
            int minCount = config.minCount();
            int maxCount = config.maxCount();
            if (++successes >= maxCount || successes >= minCount && context.m_225041_().m_216339_(0, maxCount - minCount) == 0) break;
        }
        return successes > 0;
    }

    private static void placeDisk(WorldGenLevel level, BlockPos pos, int radiusX, int radiusY, int radiusZ, RuleBasedBlockStateProvider diskProvider, BlockPredicate diskReplacer) {
        for (int x = -radiusX; x <= radiusX; ++x) {
            for (int y = -radiusY; y <= radiusY; ++y) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    BlockPos diskPos;
                    if (!(Math.pow((double)x / (double)radiusX, 2.0) + Math.pow((double)y / (double)radiusY, 2.0) + Math.pow((double)z / (double)radiusZ, 2.0) < 1.0) || !diskReplacer.test((Object)level, (Object)(diskPos = pos.m_7918_(x, y, z)))) continue;
                    level.m_7731_(diskPos, diskProvider.m_225932_(level, level.m_213780_(), diskPos), 2);
                }
            }
        }
    }
}

